<?php

declare(strict_types=1);

namespace App\Form\Common;

use App\Entity\Common\Layout\Block;
use App\Form\Type\BaseTranslationsType;
use App\Form\Type\EditorJsType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaCollectionType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Contracts\Translation\TranslatorInterface;

final class BlockType extends AbstractType
{
    public function __construct(
        private readonly TranslatorInterface $translator
    )
    {
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('template', ChoiceType::class, [
            'choices' => [
                $this->translator->trans('heading', [], 'cms') => 'heading',
                $this->translator->trans('content_block', [], 'cms') => 'html_content',
                $this->translator->trans('cover', [], 'cms') => 'cover',
                $this->translator->trans('benefits', [], 'cms') => 'benefits',
                $this->translator->trans('faqs', [], 'cms') => 'faqs',
                $this->translator->trans('highlighted_category', [], 'cms') => 'highlighted_category',
                $this->translator->trans('highlighted_lessons', [], 'cms') => 'highlighted_lessons',
                $this->translator->trans('cta_facebook', [], 'cms') => 'cta_facebook',
                $this->translator->trans('about_us', [], 'cms') => 'about_us',
                $this->translator->trans('facebook_widget', [], 'cms') => 'facebook_widget',
                $this->translator->trans('apply_form', [], 'cms') => 'apply_form',
                $this->translator->trans('apply_categories', [], 'cms') => 'apply_categories',
            ],
            'attr' => ['data-block-target' => 'input', 'data-action' => 'change->block#toggle'],
        ])
            ->add('translations', BaseTranslationsType::class, [
                'label' => false,
                'fields' => [
                    'title' => [
                        'row_attr' => ['data-block-target' => 'output', 'data-form-group' => '["image","heading","cover","benefits","cta_facebook","highlighted_lessons","apply_categories"]']
                    ],
                    'subtitle' => [
                        'row_attr' => ['data-block-target' => 'output', 'data-form-group' => '["highlighted_lessons","cta_facebook","benefits","cover"]']
                    ],
                    'lead' => [
                        'row_attr' => ['data-block-target' => 'output', 'data-form-group' => '["lead","highlighted_lessons"]']
                    ],
                    'url' => [
                        'row_attr' => ['data-block-target' => 'output', 'data-form-group' => '["youtube"]']
                    ],
                    'content' => [
                        'field_type' => EditorJsType::class,
                        'row_attr' => ['data-block-target' => 'output', 'data-form-group' => '["apply_categories","html_content","paragraph","quote","benefits","highlighted_lessons","about_us","apply_form"]']
                    ],
                    'image' => [
                        'field_type' => UxMediaType::class,
                        'conf' => 'default',
                        'row_attr' => ['data-block-target' => 'output', 'data-form-group' => '["image","cover","cta_facebook","about_us"]']
                    ],
                    'gallery' => [
                        'field_type' => UxMediaCollectionType::class,
                        'conf' => 'default',
                        'row_attr' => ['data-block-target' => 'output', 'data-form-group' => '["image","cover","cta_facebook","about_us"]']
                    ],
                ]
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Block::class,
            'locale' => ''
        ]);
    }
}
