<?php

declare(strict_types=1);

namespace App\Form\Common;

use App\Entity\Common\Tag\Tag;
use App\Repository\Common\TagRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\Autocomplete\Form\AsEntityAutocompleteField;
use Symfony\UX\Autocomplete\Form\ParentEntityAutocompleteType;

#[AsEntityAutocompleteField]
final class TagAutocompleteField extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'class' => Tag::class,
            'placeholder' => 'Choose a Tag',
            'choice_label' => static fn($tag) => $tag->getTitle(),
            'query_builder' => static fn(TagRepository $tagRepository): QueryBuilder => $tagRepository->createQueryBuilder('tag')
        ]);
    }

    public function getParent(): string
    {
        return ParentEntityAutocompleteType::class;
    }
}
