<?php

declare(strict_types=1);

namespace App\Form\Common;

use App\Entity\Common\Support\Topic;
use App\Repository\Common\TopicRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\Autocomplete\Form\AsEntityAutocompleteField;
use Symfony\UX\Autocomplete\Form\ParentEntityAutocompleteType;

#[AsEntityAutocompleteField]
final class TopicAutocompleteField extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'class' => Topic::class,
            'placeholder' => 'Choose a Topic',
            'choice_label' => static fn($topic) => $topic->getTitle(),
            'query_builder' => static fn(TopicRepository $topicRepository): QueryBuilder => $topicRepository->createQueryBuilder('topic')
        ]);
    }

    public function getParent(): string
    {
        return ParentEntityAutocompleteType::class;
    }
}
