<?php

declare(strict_types=1);

namespace App\Form\Education;

use App\Entity\Education\Exam\Exam;
use App\Form\Abstract\BaseType;
use App\Form\Type\BaseTranslationsType;
use App\Form\Type\EditorJsType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class ExamType extends BaseType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);
        if (!$builder->has('relations')) {
            $builder->add($builder->create('relations', FormType::class, ['inherit_data' => true]));
        }
        $builder->add('translations', BaseTranslationsType::class, [
            'label' => false,
            'fields' => [
                'title' => [],
                'intro' => [],
                'content' => [
                    'field_type' => EditorJsType::class,
                ]
            ]
        ])
            ->get('relations')
            ->add('image', UxMediaType::class,['conf' => 'default']);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Exam::class,
            'locale' => ''
        ]);
    }
}
