<?php

declare(strict_types=1);

namespace App\Form\Magazine\Article;

use App\Entity\Magazine\Article\Article;
use App\Repository\Magazine\Article\ArticleRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\Autocomplete\Form\AsEntityAutocompleteField;
use Symfony\UX\Autocomplete\Form\ParentEntityAutocompleteType;

#[AsEntityAutocompleteField]
final class ArticleAutocompleteField extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'class' => Article::class,

            'choice_label' => static fn($article) => $article->getTitle(),
            'query_builder' => static fn(ArticleRepository $articleRepository): QueryBuilder => $articleRepository->createQueryBuilder('article')
        ]);
    }

    public function getParent(): string
    {
        return ParentEntityAutocompleteType::class;
    }
}
