<?php

declare(strict_types=1);

namespace App\Form\System\Webspace;

use App\Entity\System\Webspace\Config;
use App\Form\Type\BaseTranslationsType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class ConfigType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('key')
            ->add('translations', BaseTranslationsType::class, [
                'label' => false,
                'fields' => [
                    'value' => [],
                    'file' => [
                        'field_type' => UxMediaType::class,
                        'conf' => 'default'
                    ]
                ]
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Config::class,
            'locale' => ''
        ]);
    }
}
