<?php

declare(strict_types=1);

namespace App\Form\System\Webspace;

use App\Entity\System\Webspace\Webspace;
use App\Form\Abstract\BaseType;
use Arkounay\Bundle\UxCollectionBundle\Form\UxCollectionType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class WebspaceType extends BaseType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);
        $builder
            ->add(
                $builder
                    ->create('general', FormType::class, ['inherit_data' => true])
                    ->add('code')
                    ->add('configs', UxCollectionType::class, [
                        'by_reference' => false,
                        'entry_type' => ConfigType::class,
                        'attr' => ['data-controller' => 'custom-collection'],
                        'allow_add' => true,
                        'allow_delete' => true,
                        'allow_drag_and_drop' => true,
                        'drag_and_drop_filter' => 'input,textarea,a,button,label',
                        'display_sort_buttons' => true,
                        'min' => 0
                    ])
            )
            ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Webspace::class,
            'locale' => ''
        ]);
    }
}
