<?php

declare(strict_types=1);

namespace App\Form\Type;

use A2lix\TranslationFormBundle\Form\EventListener\TranslationsListener;
use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use A2lix\TranslationFormBundle\Locale\LocaleProviderInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class BaseTranslationsType extends TranslationsType
{

    public function __construct(
        private readonly TranslationsListener $translationsListener,
        private readonly LocaleProviderInterface $localeProvider,
        private readonly RequestStack $requestStack
    )
    {
        parent::__construct($translationsListener, $localeProvider);
    }


    public function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);


        $resolver->setDefaults([
           'default_locale' => $this->requestStack->getCurrentRequest()->getLocale(),
            //'required_locales' => [$this->requestStack->getCurrentRequest()->getLocale()],
            //'locales' => [$this->requestStack->getCurrentRequest()->getLocale()],
            'excluded_fields' => ['createdAt', 'updatedAt', 'deletedAt', 'createdBy', 'updatedBy', 'deletedBy', 'slug'],
            //'locales' => [$this->locale],

        ]);

    }

}
