<?php

declare(strict_types=1);

namespace App\Form\User;

use App\Entity\User\User;
use App\Enum\User\UserDeletionReason;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\EnumType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class UserType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add(
                $builder
                    ->create('general', FormType::class, ['inherit_data' => true])
                    ->add('email', EmailType::class)
                    ->add('firstName')
                    ->add('lastName')
                    ->add('verified', CheckboxType::class, [
                        'required' => false
                    ])
            )
            ->add(
                $builder
                    ->create('relations', FormType::class, ['inherit_data' => true])
                    ->add('deletionReason', EnumType::class, [
                        'class' => UserDeletionReason::class,
                        'required' => false
                    ])
                    ->add('roles', ChoiceType::class, [
                        'required' => true,
                        'multiple' => true,
                        'attr' => ['class' => 'js-select'],
                        'choices' => [
                            'role_user' => 'ROLE_USER',
                        ],
                    ])
            );
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => User::class,
            'locale' => ''
        ]);
    }
}
