<?php

declare(strict_types=1);

namespace App\Repository\Common;

use App\Entity\Common\Support\Topic;
use App\Traits\Repository\Editable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

final class TopicRepository extends ServiceEntityRepository
{
    use Editable;

    public function __construct(ManagerRegistry $managerRegistry)
    {
        parent::__construct($managerRegistry, Topic::class);
    }

    public function findPublics(
        string             $locale,


    ): array
    {
        $queryBuilder = $this->createQueryBuilder('t')
            ->addSelect('tt')
            ->leftJoin('t.translations', 'tt')
            ->andWhere('tt.locale = :locale')
            ->andWhere('tt.isActive = true')
            ->andWhere('tt.deletedAt IS NULL')
            ->andWhere('t.deletedAt IS NULL')
            ->orderBy('tt.createdAt', 'ASC')
            ->setParameter('locale', $locale);

        return $queryBuilder
            ->getQuery()
            ->getResult();
    }


}
