<?php

declare(strict_types=1);

namespace App\Repository\Education;

use App\Entity\Education\Apply;
use App\Traits\Repository\Editable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

final class ApplyRepository extends ServiceEntityRepository
{
    use Editable;

    public function __construct(ManagerRegistry $managerRegistry)
    {
        parent::__construct($managerRegistry, Apply::class);
    }

    public function collectForExport(): array
    {
        $queryBuilder = $this->createQueryBuilder('a')
            //->andWhere('a.exportedAt IS NULL')
            ->andWhere('a.isVerified = true')
            ->orderBy('a.createdAt', 'DESC');

        return $queryBuilder
            ->getQuery()
            ->getResult();
    }

    public function findByDate(?string $dateFrom = null, ?string $dateTo = null): array
    {
        $queryBuilder = $this->createQueryBuilder('a')
            ->andWhere('a.isVerified = true')
            ->orderBy('a.createdAt', 'DESC');

        if ($dateFrom) {
            $queryBuilder->andWhere('a.createdAt >= :dateFrom')
                ->setParameter('dateFrom',new \DateTime($dateFrom));
        }

        if ($dateTo) {
            $queryBuilder->andWhere('a.createdAt <= :dateTo')
                ->setParameter('dateTo',new \DateTime($dateTo));
        }
        return $queryBuilder
            ->getQuery()
            ->getResult();
    }

    public function getChart(): ?array
    {
        return $this->createQueryBuilder('e')
            ->select("DATE_FORMAT(e.createdAt, '%Y-%m') as x, COUNT(e) as count")
            ->groupBy('x')
            ->addOrderBy('x', 'ASC')
            ->getQuery()->getResult();
    }

}
