<?php

declare(strict_types=1);

namespace App\Repository\Education;

use App\Entity\Education\Benefit\Benefit;
use App\Traits\Repository\Editable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

final class BenefitRepository extends ServiceEntityRepository
{
    use Editable;

    public function __construct(ManagerRegistry $managerRegistry)
    {
        parent::__construct($managerRegistry, Benefit::class);
    }

    public function findPublics($locale): array
    {
        $queryBuilder = $this->createQueryBuilder('a')
            ->addSelect('at')
            ->leftJoin('a.translations', 'at')
            ->andWhere('at.locale = :locale')
            ->andWhere('at.isActive = true')
            ->orderBy('at.createdAt', 'DESC')
            ->setParameter('locale', $locale);

        return $queryBuilder
            ->getQuery()
            ->getResult();
    }

}
