<?php

declare(strict_types=1);

namespace App\Repository\Magazine\Article;

use App\Entity\Magazine\Article\Article;
use App\Repository\Shared\PaginationAwareRepositoryTrait;
use App\Service\Pagination\Context\PaginationContext;
use App\Traits\Repository\Editable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

final class ArticleRepository extends ServiceEntityRepository
{
    use Editable, PaginationAwareRepositoryTrait;

    public function __construct(ManagerRegistry $managerRegistry)
    {
        parent::__construct($managerRegistry, Article::class);
    }

    public function findPublicArticles($locale, ?PaginationContext $paginationContext = null): array
    {
        $queryBuilder = $this->createQueryBuilder('a')
            ->addSelect('at')
            ->leftJoin('a.translations', 'at')
            ->andWhere('at.locale = :locale')
            ->andWhere('at.isActive = true')
            ->orderBy('at.createdAt', 'DESC')
            ->setParameter('locale', $locale);

        $this->applyPagination($queryBuilder, $paginationContext);

        return $queryBuilder
            ->getQuery()
            ->getResult();
    }

    public function findOneBySlug($locale, $slug): Article
    {
        return $this->createQueryBuilder('a')
            ->leftJoin('a.translations', 'trans')
            ->andWhere('trans.slug = :slug')
            ->andWhere('trans.locale = :locale')
            ->setMaxResults(1)
            ->setParameter('slug', $slug)
            ->setParameter('locale', $locale)
            ->getQuery()
            ->getOneOrNullResult();

    }

}
