<?php

namespace App\Repository\System\File;

use App\Entity\System\File\UploadGrant;
use DateTimeInterface;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class UploadGrantRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, UploadGrant::class);
    }

    public function findById(string $id): ?UploadGrant
    {
        return $this->find($id);
    }

    /**
     * @return int Affected rows
     */
    public function removeStaleUploadGrants(DateTimeInterface $before): int
    {
        return $this
            ->createQueryBuilder('ug')
            ->delete()
            ->leftJoin('ug.upload', 'u')
            ->andWhere('ug.upload is null')
            ->andWhere('ug.expiredAt < :before')
            ->setParameter('before', $before)
            ->getQuery()
            ->execute()
        ;
    }
}