<?php

namespace App\Repository\System\File;

use App\Entity\System\File\Upload;
use App\Service\FileUpload\Enum\UploadStatus;
use DateTimeInterface;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class UploadRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Upload::class);
    }

    public function findByProviderId(string $provider, string $providerId): ?Upload
    {
        return $this
            ->createQueryBuilder('u')
            ->andWhere('u.provider = :provider')
            ->andWhere('u.providerId = :providerId')
            ->setParameter('provider', $provider)
            ->setParameter('providerId', $providerId)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }

    /**
     * @return array<Upload>
     */
    public function findStale(DateTimeInterface $before): array
    {
        return $this
            ->createQueryBuilder('u')
            ->andWhere('u.status in (:states)')
            ->andWhere('u.createdAt < :before')
            ->setParameter('states', [UploadStatus::INITIALIZED, UploadStatus::IN_PROGRESS])
            ->setParameter('before', $before)
            ->getQuery()
            ->getResult()
        ;
    }
}