<?php

declare(strict_types=1);

namespace App\Repository\System;

use App\Entity\System\Message;
use App\Traits\Repository\Editable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

final class MessageRepository extends ServiceEntityRepository
{
    use Editable;

    public function __construct(ManagerRegistry $managerRegistry)
    {
        parent::__construct($managerRegistry, Message::class);
    }

    public function getChart(): ?array
    {
        return $this->createQueryBuilder('e')
            ->select("DATE_FORMAT(e.createdAt, '%Y-%m') as x, COUNT(e) as count")
            ->groupBy('x')
            ->addOrderBy('x', 'ASC')
            ->getQuery()->getResult();
    }

}
