<?php

declare(strict_types=1);

namespace App\Repository\System\Page;

use App\Entity\System\Page\Page;
use App\Traits\Repository\Editable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

final class PageRepository extends ServiceEntityRepository
{
    use Editable;

    public function __construct(ManagerRegistry $managerRegistry)
    {
        parent::__construct($managerRegistry, Page::class);
    }

    public function findOneBySlug($locale, $slug): Page
    {
        return $this->createQueryBuilder('p')
            ->leftJoin('p.translations', 'trans')
            ->andWhere('trans.slug = :slug')
            ->orWhere('trans.url = :slug')
            ->andWhere('trans.locale = :locale')
            ->setMaxResults(1)
            ->setParameter('slug', $slug)
            ->setParameter('locale', $locale)
            ->getQuery()
            ->getOneOrNullResult();

    }

}
