<?php

declare(strict_types=1);

namespace App\Security\Checker;

use App\Exception\Authentication\DeletedException;
use Symfony\Component\Security\Core\User\UserCheckerInterface;
use Symfony\Component\Security\Core\User\UserInterface;

final class DeletedUserChecker implements UserCheckerInterface
{
    public function checkPreAuth(UserInterface $user): void
    {
        if (!$user->getDeletedAt()) {
            return;
        }

        throw new DeletedException('Account is deleted');
    }

    public function checkPostAuth(UserInterface $user): void
    {
    }
}
