<?php

declare(strict_types=1);

namespace App\Security\Checker;

use App\Entity\Interfaces\VerifiableInterface;
use App\Exception\Authentication\NotVerifiedException;
use Symfony\Component\Security\Core\User\UserCheckerInterface;
use Symfony\Component\Security\Core\User\UserInterface;

final class VerifiedUserChecker implements UserCheckerInterface
{
    public function checkPreAuth(UserInterface $user): void
    {
        if (!$user instanceof VerifiableInterface) {
            return;
        }

        if ($user->isVerified()) {
            return;
        }

        throw new NotVerifiedException('Account is not verified');
    }

    public function checkPostAuth(UserInterface $user): void
    {
    }
}
