<?php

declare(strict_types=1);

namespace App\Security\RequestMatcher;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestMatcherInterface;

final class PortalLoginRequestMatcher implements RequestMatcherInterface
{
    /** @var string[] */
    final public const ROUTES = [
        'portal_api_auth_login_facebook_verify',
        'portal_api_auth_login_google_verify',
        'portal_api_auth_login_password_verify',
    ];

    public function matches(Request $request): bool
    {
        $routeName = $request->attributes->get('_route');

        return in_array($routeName, self::ROUTES, true);
    }
}
