<?php

declare(strict_types=1);

namespace App\Service\Authentication\Cookie;

use DateInterval;
use DateTime;
use Lexik\Bundle\JWTAuthenticationBundle\Services\JWTTokenManagerInterface;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\User\UserInterface;

final readonly class CookieHandler implements AuthenticationCookieFactoryInterface, AuthenticationCookieClearerInterface
{
    public function __construct(
        private JWTTokenManagerInterface $jwtTokenManager,
        private ParameterBagInterface    $parameterBag
    )
    {
    }

    public function create(UserInterface $user): Cookie
    {
        $jwtToken = $this->jwtTokenManager->create($user);
        $ttl = $this->parameterBag->get('app.authentication.portal.ttl');
        $expiry = (new DateTime())->add(new DateInterval('PT' . $ttl . 'S'));

        return new Cookie('BEARER', $jwtToken, $expiry, '/', null, false);
    }

    public function clear(Response $response): void
    {
        $response->headers->clearCookie('BEARER', '/');
    }
}
