<?php

declare(strict_types=1);

namespace App\Service\Authentication\Verification\Checker;

use App\Entity\User\User;
use App\Repository\User\UserRepository;
use App\Service\Authentication\Verification\ValueObject\VerificationToken;

final readonly class VerificationTokenUniquenessChecker implements VerificationTokenCheckerInterface
{
    public function __construct(
        private UserRepository $userRepository
    )
    {
    }

    public function check(VerificationToken $verificationToken): bool
    {
        return $this->userRepository->findByVerificationToken($verificationToken->getToken()) instanceof User;
    }
}
