<?php

declare(strict_types=1);

namespace App\Service\Authentication\Verification\Generator;

use App\Service\Authentication\Verification\Checker\VerificationTokenCheckerInterface;
use App\Service\Authentication\Verification\ValueObject\VerificationToken;
use Symfony\Component\String\ByteString;

final readonly class VerificationTokenGenerator implements VerificationTokenGeneratorInterface
{
    public function __construct(
        private VerificationTokenCheckerInterface $verificationTokenChecker,
        private int                               $length
    )
    {
    }

    public function generate(): VerificationToken
    {
        do {
            $tokenValue = ByteString::fromRandom($this->length)->toString();
            $token = new VerificationToken($tokenValue);
        } while ($this->verificationTokenChecker->check($token));

        return $token;
    }
}
