<?php

declare(strict_types=1);

namespace App\Service\Authentication\Verification\ValueObject;

use Stringable;

final readonly class VerificationToken implements Stringable
{
    public function __construct(
        private string $token
    )
    {
    }

    public function getToken(): string
    {
        return $this->token;
    }

    public function __toString(): string
    {
        return $this->token;
    }
}
