<?php

declare(strict_types=1);

namespace App\Service\Block;

use App\Entity\Common\Layout\Block;
use App\Entity\Education\Apply;
use App\Entity\System\Message;
use App\Form\Education\App\ApplyType;
use App\Form\Education\App\MessageType;
use App\Repository\Common\TopicRepository;
use App\Repository\Education\BenefitRepository;
use App\Repository\Education\Lesson\CategoryRepository;
use App\Repository\Education\Lesson\LessonRepository;
use Symfony\Component\Form\FormFactoryBuilderInterface;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\Form\Test\FormBuilderInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Twig\Environment;

final readonly class BlockProcessor implements BlockProcessorInterface
{
    public function __construct(
        private Environment           $twig,
        private BenefitRepository     $benefitRepository,
        private TopicRepository       $topicRepository,
        private CategoryRepository    $categoryRepository,
        private LessonRepository    $lessonRepository,
        private FormFactoryInterface  $builder,
        private UrlGeneratorInterface $urlGenerator
    )
    {
    }

    public function process(Block $block)
    {
        $data = [
            'block' => $block
        ];

        switch ($block->getTemplate()) {
            case 'benefits' :
                $data['benefits'] = $this->benefitRepository->findAll();
                break;

            case 'faqs' :
                $data['topics'] = $this->topicRepository->findAll();
                break;

            case 'highlighted_category' :
                $data['category'] = $this->categoryRepository->findOneHighlighted('hu');
                break;

            case 'highlighted_lessons' :
                $data['lessons'] = $this->lessonRepository->findHighlighteds('hu');
                break;

            case 'apply_form' :
                $apply = new Apply();

                $form = $this->builder->createBuilder(ApplyType::class, $apply, [
                    'action' => $this->urlGenerator->generate('app_apply')
                ])->getForm();

                $data['form'] = $form->createView();
                break;

            case 'apply_categories' :
                $data['categories'] = $this->categoryRepository->findByApply('hu');
                $data['table_categories'] = $this->categoryRepository->findAllByApply('hu');
                break;
        }


        return $this->twig->render('portal/blocks/' . $block->getTemplate() . '.html.twig', $data);
    }

}
