<?php

declare(strict_types=1);

namespace App\Service\Command\Adapter;

use App\Service\Command\CommandInterface;
use Exception;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Messenger\Stamp\HandledStamp;

final readonly class MessengerCommandBusAdapter implements CommandBusAdapterInterface
{
    public function __construct(
        private MessageBusInterface $messageBus
    )
    {
    }

    /**
     * @throws Exception
     */
    public function handle(CommandInterface $command): mixed
    {
        $envelope = $this->messageBus->dispatch($command);

        return $envelope->last(HandledStamp::class)?->getResult();
    }
}
