<?php

declare(strict_types=1);

namespace App\Service\Command;

use App\Service\Command\Adapter\CommandBusAdapterInterface;

final readonly class CommandBus implements CommandBusInterface
{
    public function __construct(
        private CommandBusAdapterInterface $commandBusAdapter
    )
    {
    }

    public function handle(CommandInterface $command): mixed
    {
        return $this->commandBusAdapter->handle($command);
    }
}
