<?php

namespace App\Service\Filter\Resolver;

use App\Exception\View\ConstraintViolationException;
use App\Service\Filter\Model\FilterInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Controller\ValueResolverInterface;
use Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadata;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

readonly class FilterValueResolver implements ValueResolverInterface
{
    public function __construct(
        private SerializerInterface $serializer,
        private ValidatorInterface  $validator
    )
    {
    }

    public function resolve(Request $request, ArgumentMetadata $argument): iterable
    {
        $argumentType = $argument->getType();

        if ($argumentType === null || !is_subclass_of($argumentType, FilterInterface::class)) {
            return [];
        }

        $filterData = $request->get('filter', '{}');

        $filter = $this->serializer->deserialize($filterData, $argumentType, 'json', [
            DenormalizerInterface::COLLECT_DENORMALIZATION_ERRORS => true,
        ]);

        $violations = $this->validator->validate($filter);

        if ($violations->count() > 0) {
            throw new ConstraintViolationException($violations);
        }

        return [$filter];
    }
}