<?php

namespace App\Service\Layout\Compiler\Event;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Node;
use Symfony\Contracts\EventDispatcher\Event;

final class ChildAddedEvent extends Event
{
    public function __construct(
        private readonly Node            $parent,
        private readonly Node            $child,
        private readonly CompilerContext $context
    )
    {
    }

    public function getParent(): Node
    {
        return $this->parent;
    }

    public function getChild(): Node
    {
        return $this->child;
    }

    public function getContext(): CompilerContext
    {
        return $this->context;
    }
}