<?php

namespace App\Service\Layout\Compiler\Event;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Node;
use Symfony\Contracts\EventDispatcher\Event;

final class NodeCompiledEvent extends Event
{
    public function __construct(
        private readonly Node            $widget,
        private readonly CompilerContext $context
    )
    {
    }

    public function getWidget(): Node
    {
        return $this->widget;
    }

    public function getContext(): CompilerContext
    {
        return $this->context;
    }
}