<?php

namespace App\Service\Layout\Compiler\Event;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Node;
use Symfony\Contracts\EventDispatcher\Event;

final class PreAddChildEvent extends Event
{
    private bool $cancelled = false;

    public function __construct(
        private readonly Node            $parent,
        private Node                     $child,
        private readonly CompilerContext $context
    )
    {
    }

    public function getParent(): Node
    {
        return $this->parent;
    }

    public function getChild(): Node
    {
        return $this->child;
    }

    public function setChild(Node $child): void
    {
        $this->child = $child;
    }

    public function getContext(): CompilerContext
    {
        return $this->context;
    }

    public function isCancelled(): bool
    {
        return $this->cancelled;
    }

    public function setCancelled(bool $cancelled): void
    {
        $this->cancelled = $cancelled;
    }
}