<?php

namespace App\Service\Layout\Compiler\Event;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Node;
use Symfony\Contracts\EventDispatcher\Event;

final class PreCompileNodeEvent extends Event
{
    private bool $cancelled = false;

    public function __construct(
        private Node                     $node,
        private readonly CompilerContext $context
    )
    {
    }

    public function getNode(): Node
    {
        return $this->node;
    }

    public function setNode(Node $node): void
    {
        $this->node = $node;
    }

    public function getContext(): CompilerContext
    {
        return $this->context;
    }

    public function isCancelled(): bool
    {
        return $this->cancelled;
    }

    public function setCancelled(bool $cancelled): void
    {
        $this->cancelled = $cancelled;
    }
}