<?php

namespace App\Service\Layout\Compiler\Exception;

use Exception;

final class StampNotFoundException extends Exception
{
    public function __construct(
        private readonly string $stampClass
    )
    {
        parent::__construct(sprintf(
            'Stamp not found for class: %s',
            $this->stampClass
        ));
    }

    public function getStampClass(): string
    {
        return $this->stampClass;
    }
}