<?php

namespace App\Service\Layout\Compiler\Stamp;

use App\Helper\PrioritizableInterface;
use App\Service\Layout\Widget\Page\OpenGraph\Article\Gender;
use DateTimeInterface;

final readonly class OpenGraphArticleStamp implements StampInterface, PrioritizableInterface
{
    public function __construct(
        private ?DateTimeInterface $publishedTime,
        private ?DateTimeInterface $modifiedTime,
        private ?DateTimeInterface $expirationTime,
        private ?string            $authorFirstName,
        private ?string            $authorLastName,
        private ?string            $authorUsername,
        private ?Gender            $authorGender,
        private ?string            $section,
        private array              $tag,
        private int                $priority
    )
    {
    }

    public function getPublishedTime(): ?DateTimeInterface
    {
        return $this->publishedTime;
    }

    public function getModifiedTime(): ?DateTimeInterface
    {
        return $this->modifiedTime;
    }

    public function getExpirationTime(): ?DateTimeInterface
    {
        return $this->expirationTime;
    }

    public function getAuthorFirstName(): ?string
    {
        return $this->authorFirstName;
    }

    public function getAuthorLastName(): ?string
    {
        return $this->authorLastName;
    }

    public function getAuthorUsername(): ?string
    {
        return $this->authorUsername;
    }

    public function getAuthorGender(): ?Gender
    {
        return $this->authorGender;
    }

    public function getSection(): ?string
    {
        return $this->section;
    }

    public function getTag(): array
    {
        return $this->tag;
    }

    public function getPriority(): int
    {
        return $this->priority;
    }
}