<?php

namespace App\Service\Layout\Compiler\Stamp;

use App\Helper\PrioritizableInterface;
use App\Service\Layout\Widget\Page\OpenGraph\Meta\ObjectType;

final readonly class OpenGraphMetaStamp implements StampInterface, PrioritizableInterface
{
    public function __construct(
        private ?string     $siteName,
        private ?string     $title,
        private ?string     $description,
        private ?ObjectType $type,
        private ?string     $url,
        private int         $priority
    )
    {
    }

    public function getSiteName(): ?string
    {
        return $this->siteName;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getType(): ?ObjectType
    {
        return $this->type;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function getPriority(): int
    {
        return $this->priority;
    }
}