<?php

namespace App\Service\Layout\Widget\ArticleBox;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Node;
use App\Service\Layout\Compiler\NodeCompilerInterface;
use Symfony\Component\Serializer\Exception\ExceptionInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

readonly class ArticleBoxCompiler implements NodeCompilerInterface
{
    public function __construct(
        private DenormalizerInterface $denormalizer
    )
    {
    }

    public function supports(Node $node, CompilerContext $context): bool
    {
        $properties = $node->getProperties();

        return $node->getType() === 'article_box'
            && (is_array($properties) || $properties instanceof ArticleBoxProperties);
    }

    /**
     * @throws ExceptionInterface
     */
    public function compile(Node $node, CompilerContext $context): Node
    {
        $properties = $node->getProperties();

        if (is_array($properties)) {
            $properties = $this->denormalizer->denormalize($properties, ArticleBoxProperties::class);

        }

        return $node->setProperties($properties);
    }
}