<?php

namespace App\Service\Layout\Widget\Menu;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Enum\CompileMode;
use App\Service\Layout\Compiler\Node;
use App\Service\Layout\Compiler\NodeCompilerInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

readonly class MenuCompiler implements NodeCompilerInterface
{
    public function __construct(
        private DenormalizerInterface $denormalizer
    )
    {
    }

    public function supports(Node $node, CompilerContext $context): bool
    {
        $properties = $node->getProperties();

        return $context->getMode() === CompileMode::STATEFUL
            && $node->getType() === 'menu'
            && (is_array($properties) || $properties instanceof MenuStatefulProperties);
    }

    public function compile(Node $node, CompilerContext $context): Node
    {
        /** @var MenuStatefulProperties $properties */
        $properties = $node->getProperties();

        if (is_array($properties)) {
            $properties = $this->denormalizer->denormalize($properties, MenuStatefulProperties::class);
        }

        $menuId = $properties->getMenuId();

        // TODO: get menu
        $items = [];
        // TODO: map menu items

        $finalProperties = new MenuFinalProperties($items);

        return $node->setProperties($finalProperties);
    }
}