<?php

namespace App\Service\Layout\Widget\Page\OpenGraph\Image;

final readonly class Image
{
    public function __construct(
        private ?string $url,
        private ?string $secureUrl,
        private ?string $type,
        private ?int    $width,
        private ?int    $height,
        private ?string $alt
    )
    {
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function getSecureUrl(): ?string
    {
        return $this->secureUrl;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getWidth(): ?int
    {
        return $this->width;
    }

    public function getHeight(): ?int
    {
        return $this->height;
    }

    public function getAlt(): ?string
    {
        return $this->alt;
    }
}