<?php

namespace App\Service\Layout\Widget\Page\OpenGraph\Image;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Exception\StampNotFoundException;
use App\Service\Layout\Compiler\Node;
use App\Service\Layout\Compiler\Stamp\OpenGraphImageStamp;
use App\Service\Layout\Compiler\StampProcessorInterface;
use App\Service\Layout\Widget\Page\PageProperties;

readonly class ImageStampProcessor implements StampProcessorInterface
{
    public function supports(Node $node, CompilerContext $context): bool
    {
        return $node->getType() === 'page'
            && $node->getProperties() instanceof PageProperties
            && $context->hasStamp(OpenGraphImageStamp::class);
    }

    /**
     * @throws StampNotFoundException
     */
    public function process(Node $node, CompilerContext $context): Node
    {
        /** @var OpenGraphImageStamp $stamp */
        $stamp = $context->getHighestPriorityStamp(OpenGraphImageStamp::class);

        $image = new Image(
            $stamp->getUrl(),
            $stamp->getSecureUrl(),
            $stamp->getType(),
            $stamp->getWidth(),
            $stamp->getHeight(),
            $stamp->getAlt()
        );

        /** @var PageProperties $properties */
        $properties = $node->getProperties();

        $openGraph = $properties->getOpenGraph();
        $openGraph = $openGraph->setImage($image);

        $properties = $properties->setOpenGraph($openGraph);

        return $node->setProperties($properties);
    }
}