<?php

namespace App\Service\Layout\Widget\Page\OpenGraph;

use App\Service\Layout\Widget\Page\OpenGraph\Article\Article;
use App\Service\Layout\Widget\Page\OpenGraph\Image\Image;
use App\Service\Layout\Widget\Page\OpenGraph\Meta\Meta;

final readonly class OpenGraph
{
    public function __construct(
        private ?Meta    $meta = null,
        private ?Image   $image = null,
        private ?Article $article = null
    )
    {
    }

    public function getMeta(): ?Meta
    {
        return $this->meta;
    }

    public function setMeta(?Meta $meta): self
    {
        return new self(
            $meta,
            $this->image,
            $this->article
        );
    }

    public function getImage(): ?Image
    {
        return $this->image;
    }

    public function setImage(?Image $image): self
    {
        return new self(
            $this->meta,
            $image,
            $this->article
        );
    }

    public function getArticle(): ?Article
    {
        return $this->article;
    }

    public function setArticle(?Article $article): self
    {
        return new self(
            $this->meta,
            $this->image,
            $article
        );
    }
}