<?php

namespace App\Service\Layout\Widget\Page\PageMeta;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Exception\StampNotFoundException;
use App\Service\Layout\Compiler\Node;
use App\Service\Layout\Compiler\Stamp\PageMetaStamp;
use App\Service\Layout\Compiler\StampProcessorInterface;
use App\Service\Layout\Widget\Page\PageProperties;

class PageMetaStampProcessor implements StampProcessorInterface
{
    public function supports(Node $node, CompilerContext $context): bool
    {
        return $node->getType() === 'page'
            && $node->getProperties() instanceof PageProperties
            && $context->hasStamp(PageMetaStamp::class);
    }

    /**
     * @throws StampNotFoundException
     */
    public function process(Node $node, CompilerContext $context): Node
    {
        /** @var PageMetaStamp $stamp */
        $stamp = $context->getHighestPriorityStamp(PageMetaStamp::class);

        $meta = new PageMeta(
            $stamp->getTitle(),
            $stamp->getDescription(),
            $stamp->getKeywords()
        );

        /** @var PageProperties $properties */
        $properties = $node->getProperties();
        $properties = $properties->setPageMeta($meta);

        return $node->setProperties($properties);
    }
}