<?php

namespace App\Service\Layout\Widget\Page;

use App\Service\Layout\Compiler\PropertiesInterface;
use App\Service\Layout\Widget\Page\OpenGraph\OpenGraph;
use App\Service\Layout\Widget\Page\PageMeta\PageMeta;
use App\Service\Layout\Widget\Page\Twitter\TwitterMeta;

final readonly class PageProperties implements PropertiesInterface
{
    public function __construct(
        private PageMeta    $pageMeta = new PageMeta(),
        private OpenGraph   $openGraph = new OpenGraph(),
        private TwitterMeta $twitterMeta = new TwitterMeta()
    )
    {
    }

    public function getPageMeta(): PageMeta
    {
        return $this->pageMeta;
    }

    public function setPageMeta(PageMeta $pageMeta): self
    {
        return new self(
            $pageMeta,
            $this->openGraph,
            $this->twitterMeta
        );
    }

    public function getOpenGraph(): OpenGraph
    {
        return $this->openGraph;
    }

    public function setOpenGraph(OpenGraph $openGraph): self
    {
        return new self(
            $this->pageMeta,
            $openGraph,
            $this->twitterMeta
        );
    }

    public function getTwitterMeta(): TwitterMeta
    {
        return $this->twitterMeta;
    }

    public function setTwitterMeta(TwitterMeta $twitterMeta): self
    {
        return new self(
            $this->pageMeta,
            $this->openGraph,
            $twitterMeta
        );
    }
}