<?php

namespace App\Service\Layout\Widget\Page\Twitter;

final readonly class TwitterMeta
{
    public function __construct(
        private ?CardType $cardType = null,
        private ?string   $site = null,
        private ?string   $creator = null
    )
    {
    }

    public function getCardType(): ?CardType
    {
        return $this->cardType;
    }

    public function getSite(): ?string
    {
        return $this->site;
    }

    public function getCreator(): ?string
    {
        return $this->creator;
    }
}