<?php

namespace App\Service\Layout\Widget\Page\Twitter;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Exception\StampNotFoundException;
use App\Service\Layout\Compiler\Node;
use App\Service\Layout\Compiler\Stamp\TwitterMetaStamp;
use App\Service\Layout\Compiler\StampProcessorInterface;
use App\Service\Layout\Widget\Page\PageProperties;

readonly class TwitterMetaStampProcessor implements StampProcessorInterface
{
    public function supports(Node $node, CompilerContext $context): bool
    {
        return $node->getType() === 'page'
            && $node->getProperties() instanceof PageProperties
            && $context->hasStamp(TwitterMetaStamp::class);
    }

    /**
     * @throws StampNotFoundException
     */
    public function process(Node $node, CompilerContext $context): Node
    {
        /** @var TwitterMetaStamp $stamp */
        $stamp = $context->getHighestPriorityStamp(TwitterMetaStamp::class);

        $meta = new TwitterMeta(
            $stamp->getCardType(),
            $stamp->getSite(),
            $stamp->getCreator()
        );

        /** @var PageProperties $properties */
        $properties = $node->getProperties();
        $properties->setTwitterMeta($meta);

        return $node->setProperties($properties);
    }
}