<?php

declare(strict_types=1);

namespace App\Service\Pagination\Context;

use Symfony\Component\Validator\Constraints\Range;

final readonly class PaginationContext implements PaginationContextInterface
{
    public function __construct(
        #[Range(min: 1)]
        private int $page = 1,
        #[Range(min: 1, max: 100)]
        private int $itemsPerPage = 15
    )
    {
    }

    public function getPage(): int
    {
        return $this->page;
    }

    public function getItemsPerPage(): int
    {
        return $this->itemsPerPage;
    }
}
