<?php

namespace App\Service\Pagination\Resolver;

use App\Exception\View\ConstraintViolationException;
use App\Service\Pagination\Context\PaginationContext;
use App\Service\Pagination\Context\PaginationContextInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Controller\ValueResolverInterface;
use Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadata;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

readonly class PaginationContextValueResolver implements ValueResolverInterface
{
    public function __construct(
        private SerializerInterface $serializer,
        private ValidatorInterface $validator
    )
    {
    }

    public function resolve(Request $request, ArgumentMetadata $argument): iterable
    {
        $argumentType = $argument->getType();

        if ($argumentType === null || !is_a($argumentType, PaginationContextInterface::class, true)) {
            return [];
        }

        $filterData = $request->get('pagination', '{}');

        if ($argumentType === PaginationContextInterface::class) {
            $argumentType = PaginationContext::class;
        }

        $pagination = $this->serializer->deserialize($filterData, $argumentType, 'json', [
            DenormalizerInterface::COLLECT_DENORMALIZATION_ERRORS => true,
        ]);

        $violations = $this->validator->validate($pagination);

        if ($violations->count() > 0) {
            throw new ConstraintViolationException($violations);
        }

        return [$pagination];
    }
}