<?php

declare(strict_types=1);

namespace App\Service\Recaptcha;

use DS\Library\ReCaptcha\Http\Driver\DriverInterface;
use DS\Library\ReCaptcha\ReCaptcha;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;

final readonly class RecaptchaService
{
    public function __construct(
        private RequestStack          $requestStack,
        private ParameterBagInterface $parameterBag,
        private DriverInterface       $driver,
    )
    {
    }

    public function verify(string $token): bool
    {
        $enabled = $this->parameterBag->get('app.recaptcha.enabled');

        if (!$enabled) {
            return true;
        }

        $request = $this->requestStack->getMainRequest();

        if (!$request instanceof Request) {
            return true;
        }

        $reCaptcha = new ReCaptcha(
            $this->parameterBag->get('app.recaptcha.private_key'),
            $request->getClientIp(),
            $token
        );

        return $reCaptcha
            ->buildRequest($this->driver)
            ->send()
            ->isSuccess();
    }
}
