<?php

declare(strict_types=1);

namespace App\Service\Recaptcha;

use DS\Library\ReCaptcha\Http\Driver\DriverInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

final readonly class SymfonyHttpClientDriver implements DriverInterface
{
    public function __construct(
        private HttpClientInterface $httpClient
    )
    {
    }

    public function get(mixed $url, array $parameters = []): string
    {
        $response = $this->httpClient->request('GET', $url, [
            'query' => $parameters
        ]);

        return $response->getContent(false);
    }
}
