<?php

declare(strict_types=1);

namespace App\Service\Social;

use KnpU\OAuth2ClientBundle\Client\OAuth2ClientInterface;
use KnpU\OAuth2ClientBundle\Client\Provider\FacebookClient as ProviderFacebookClient;
use League\OAuth2\Client\Provider\AbstractProvider;
use League\OAuth2\Client\Provider\Exception\IdentityProviderException;
use League\OAuth2\Client\Provider\FacebookUser;
use League\OAuth2\Client\Token\AccessToken;
use League\OAuth2\Client\Token\AccessTokenInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

final readonly class FacebookClient implements OAuth2ClientInterface
{
    public function __construct(
        private ProviderFacebookClient $providerFacebookClient
    )
    {
    }

    public function fetchUser(): FacebookUser
    {
        return $this->providerFacebookClient->fetchUser();
    }

    public function setAsStateless(): void
    {
        $this->providerFacebookClient->setAsStateless();
    }

    public function redirect(array $scopes, array $options): RedirectResponse
    {
        return new RedirectResponse(
            $this->getUrl()
        );
    }

    public function getUrl(): string
    {
        return $this->providerFacebookClient->getOAuth2Provider()->getAuthorizationUrl();
    }

    public function getOAuth2Provider(): AbstractProvider
    {
        return $this->providerFacebookClient->getOAuth2Provider();
    }

    public function getAccessToken(array $options = []): AccessToken|AccessTokenInterface
    {
        return $this->providerFacebookClient->getAccessToken($options);
    }

    public function fetchUserFromToken(AccessToken $accessToken): FacebookUser
    {
        return $this->providerFacebookClient->fetchUserFromToken($accessToken);
    }

    /**
     * @throws IdentityProviderException
     */
    public function refreshAccessToken(string $refreshToken, array $options = []): AccessToken
    {
        return $this->providerFacebookClient->refreshAccessToken($refreshToken, $options);
    }
}
