<?php

declare(strict_types=1);

namespace App\Service\Social;

use App\Service\Url\PortalUrlGeneratorInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RequestContext;

final readonly class HostAwareUrlGenerator implements UrlGeneratorInterface
{
    public function __construct(
        private UrlGeneratorInterface       $urlGenerator,
        private PortalUrlGeneratorInterface $portalUrlGenerator
    )
    {
    }

    public function setContext(RequestContext $context): mixed
    {
        return $this->urlGenerator->setContext($context);
    }

    public function getContext(): RequestContext
    {
        return $this->urlGenerator->getContext();
    }

    public function generate(string $name, array $parameters = [], int $referenceType = self::ABSOLUTE_PATH): string
    {
        if (str_contains($name, 'google')) {
            return $this->portalUrlGenerator->generateGoogleCallbackUrl();
        }

        if (str_contains($name, 'facebook')) {
            return $this->portalUrlGenerator->generateFacebookCallbackUrl();
        }

        return $this->urlGenerator->generate($name, $parameters, $referenceType);
    }
}
